<?php

namespace ADP\BaseVersion\Includes\AdminExtensions\AdminPage\Tabs;

use ADP\BaseVersion\Includes\Context;
use ADP\BaseVersion\Includes\AdminExtensions\AdminPage\AdminTabInterface;

defined('ABSPATH') or exit;

class Help implements AdminTabInterface
{
    /**
     * @var string
     */
    protected $title;

    /**
     * @var Context
     */
    protected $context;

    public function __construct($deprecated = null)
    {
        $this->context = adp_context();
        $this->title   = self::getTitle();
    }

    public function withContext(Context $context)
    {
        $this->context = $context;
    }

    public function handleSubmitAction()
    {
        // do nothing
    }

    public function getViewVariables()
    {
        return array();
    }

    public static function getRelativeViewPath()
    {
        return 'admin_page/tabs/help.php';
    }

    public static function getHeaderDisplayPriority()
    {
        return 50;
    }

    public static function getKey()
    {
        return 'help';
    }

    public static function getTitle()
    {
        return __('Help', 'advanced-dynamic-pricing-for-woocommerce');
    }

    public function enqueueScripts()
    {
    }

    public function registerAjax()
    {

    }
}
