<?php

namespace ADP\BaseVersion\Includes\Compatibility;

use ADP\BaseVersion\Includes\Context;
use WC_Deposits_Cart_Manager;

defined('ABSPATH') or exit;

class WcDepositsCmp
{
    /**
     * @var Context
     */
    protected $context;

    /**
     * @param null $deprecated
     */
    public function __construct($deprecated = null)
    {
        $this->context = adp_context();
    }

    public function withContext(Context $context)
    {
        $this->context = $context;
    }

    /**
     * @return bool
     */
    public function isActive()
    {
        return defined("WC_DEPOSITS_VERSION");
    }

    /**
     * @param \WC_Cart $wcCart
     */
    public function updateDepositsData($wcCart)
    {
        if ( ! class_exists("WC_Deposits_Cart_Manager")) {
            return;
        }

        WC_Deposits_Cart_Manager::get_instance()->get_cart_from_session($wcCart);

        $wcNoFilterWorker = new \ADP\BaseVersion\Includes\WC\WcNoFilterWorker();
        $wcNoFilterWorker->calculateTotals($wcCart, $wcNoFilterWorker::FLAG_ALLOW_TOTALS_HOOKS);
    }
}
